﻿package Print2Flash {
	import flash.display.Loader;
	import flash.events.*;
	import flash.net.*;
	import flash.utils.*;
	import flash.display.*;
	import flash.geom.*;

	public class Print2FlashDoc  extends Loader {
		private var Loaded:Boolean=false
		private var Unloading:Boolean=false
		private var connstr:String
		private var APILC:LocalConnection
		private var intervalID:Number
		private var contentwidth,contentheight:Number
		private var beforeFSWidth:Number,beforeFSHeight:Number
		private var ourFS:Boolean=false;

		public function Print2FlashDoc(url,x,y,width,height,parent) {
			this.x=x
			this.y=y
			contentwidth=width;
			contentheight=height;
			loadDoc(url);
			parent.addChild(this);
			stage.addEventListener(FullScreenEvent.FULL_SCREEN,	onFullScreen ,false, 0, true);
		}
		
		public function loadDoc(url:String):void {
			if (Loaded) throw new DocAlreadyLoaded();

			connstr = "_" + new Date().time.toString()+Math.random();
			APILC = new LocalConnection();

			if (url.indexOf("?")!=-1) url+="&"; else url+="?";
			url+="connstr="+connstr+"&conndomain="+APILC.domain;
				
			APILC.client=this;
			APILC.allowDomain("*");
			APILC.addEventListener(StatusEvent.STATUS,OnAPILCStatus);
			APILC.connect(connstr+"_Events");			

			var request:URLRequest = new URLRequest(url);
			contentLoaderInfo.addEventListener(Event.INIT,initHandler)
			Loaded=Unloading=false;
			load(request);
		}

		var i:int=0
		public override function unload():void {
			uninit();
		}
		
		private function initHandler(event:Event):void {
			intervalID = setInterval(loadFunc, 100);
    	}	
	
		private function OnAPILCStatus(E:StatusEvent):void {
//			trace(E)
			if (!Loaded) {
				Loaded = E.level=="status";
			}
			else if (Unloading) {
				try {
					super.unload()
					APILC.close();
				}
				catch(e) {}
				Loaded=Unloading=false;
				dispatchEvent(new UnloadCompletedEvent());
			}
		}
	
		private function loadFunc()
		{
		   if (!Loaded) init()
			 else {
				clearInterval(intervalID);
				dispatchEvent(new Event("onLoaded"));
			 }
		}

		private function init()
		{			
			APILC.send(connstr,"init",contentwidth,contentheight);
		}

		private function uninit()
		{			
			if (APILC) {
				Unloading=true;
				APILC.send(connstr,"uninit");
			}
		}
		
		private var CBNum:Number=1;
		private var CBArray:Object=new Object()
		private function RegisterCBFunc(CBFunc:Function):String {
			var ID:String=(CBNum++).toString()
			CBArray[ID]=CBFunc
			return ID;
		}

		private function CallCBFunc(ID:String,Param:Object):void {
			CBArray[ID](Param);
			delete CBArray[ID];
		}

		public function CallBack(CBID:String,Param:Object):void {
			CallCBFunc(CBID,Param)
		}			
		
		private function onFullScreen(event:FullScreenEvent):void {
			if (!event.fullScreen && ourFS) {
				ourFS=false;
				setSize(beforeFSWidth, beforeFSHeight);  
			}
		}
		
		// API Functions
		public function setCurrentPage(page:Number):void {
			APILC.send(connstr,"setCurrentPage",page);
		}
		
		public function getCurrentPage(CBFunc:Function):void {
			APILC.send(connstr,"getCurrentPage",RegisterCBFunc(CBFunc));
		}
		
		public function setSize(width:Number, height:Number):void {
			contentwidth=width
			contentheight=height
			APILC.send(connstr,"setSize",width,height);
		}

		public function setScrollPosition(pos:Object):void {
			APILC.send(connstr,"setScrollPosition",pos);
		}			

		public function getMaxScrollPosition(CBFunc:Function):void {
			APILC.send(connstr,"getMaxScrollPosition",RegisterCBFunc(CBFunc));
		}			

		public function getScrollPosition(CBFunc:Function):void {
			APILC.send(connstr,"getScrollPosition",RegisterCBFunc(CBFunc));
		}			

		public function PreviousPage():void {
			APILC.send(connstr,"PreviousPage");				
		}

		public function NextPage():void {
			APILC.send(connstr,"NextPage");				
		}			

		public function getVisibleArea(CBFunc:Function):void {
			APILC.send(connstr,"getVisibleArea",RegisterCBFunc(CBFunc));
		}			

		public function setVisibleArea(area:Object):void {
			APILC.send(connstr,"setVisibleArea",area);
		}			
		
		public function setCurrentZoom(zoom:Object):void {
			APILC.send(connstr,"setCurrentZoom",zoom);
		}			

		public function getCurrentZoom(CBFunc:Function):void {
			APILC.send(connstr,"getCurrentZoom",RegisterCBFunc(CBFunc));
		}			
		
		public function setCurrentTool(tool:String):void {
			APILC.send(connstr,"setCurrentTool",tool);
		}			

		public function getCurrentTool(CBFunc:Function):void {
			APILC.send(connstr,"getCurrentTool",RegisterCBFunc(CBFunc));
		}			
		
		public function setControlVisibility(mask:Number):void {
			APILC.send(connstr,"setControlVisibility",mask);
		}						

		public function SearchText(text:String,CBFunc:Function):void {
			APILC.send(connstr,"SearchText",RegisterCBFunc(CBFunc),text);
		}			
		
		public function findNext(CBFunc:Function):void {
			APILC.send(connstr,"findNext",RegisterCBFunc(CBFunc));
		}			
		
		public function ResetTextSearch():void {
			APILC.send(connstr,"ResetTextSearch");
		}						
		
		public function setFindText(text:String):void {
			APILC.send(connstr,"setFindText",text);
		}						

		public function getFindText(CBFunc:Function):void {
			APILC.send(connstr,"getFindText",RegisterCBFunc(CBFunc));
		}						
		
		public function setTextSelectionRange(sel:Object):void {
			APILC.send(connstr,"setTextSelectionRange",sel);
		}						

		public function getTextSelectionRange(CBFunc:Function):void {
			APILC.send(connstr,"getTextSelectionRange",RegisterCBFunc(CBFunc));
		}						

		public function getNumberOfPages(CBFunc:Function):void {
			APILC.send(connstr,"getNumberOfPages",RegisterCBFunc(CBFunc));
		}						
		
		public function OpenHelpPage():void {
			APILC.send(connstr,"OpenHelpPage");
		}						
		
		public function OpenInNewWindow():void {
			APILC.send(connstr,"OpenInNewWindow");
		}						
		
		public function printTheDocument():void {
			APILC.send(connstr,"printTheDocument");
		}						
		
		public function Rotate():void {
			APILC.send(connstr,"Rotate");
		}						
		
		public function getLoadedPages(CBFunc:Function):void {
			APILC.send(connstr,"getLoadedPages",RegisterCBFunc(CBFunc));
		}						
		
		public function setLanguage(lang:String):void {
			APILC.send(connstr,"setLanguage",lang);
		}						
		
		public function adjustToolbarColor(hue:Number,saturation:Number,brightness:Number,contrast:Number):void {
			APILC.send(connstr,"adjustToolbarColor",hue,saturation,brightness,contrast);
		}						
		
		public function enableScrolling(enable:Boolean):void {
			APILC.send(connstr,"enableScrolling",enable);
		}						
		
		public function getSelectedText(CBFunc:Function):void {
			APILC.send(connstr,"getSelectedText",RegisterCBFunc(CBFunc));
		}						
		
		public function setVisiblePages(from,_to:Number):void {
			APILC.send(connstr,"setVisiblePages",from,_to);
		}						
		
		public function NavBack(CBFunc:Function):void {
			APILC.send(connstr,"NavBack",RegisterCBFunc(CBFunc));
		}						

		public function NavForward(CBFunc:Function):void {
			APILC.send(connstr,"NavForward",RegisterCBFunc(CBFunc));
		}						 
		
		public function scrollLine(lineNumber:Number):void {
			APILC.send(connstr,"scrollLine",lineNumber);
		}		

		public function goToLinkTarget(CBFunc:Function, url:String, window:String):void {
			APILC.send(connstr,"goToLinkTarget",RegisterCBFunc(CBFunc),url,window);
		}		
		
		public function setFullScreen(fullScreen:Boolean):void {
			if (fullScreen) {
				try {
					beforeFSWidth=contentwidth;
					beforeFSHeight=contentheight;					
					setSize(stage["fullScreenWidth"], stage["fullScreenHeight"]);
					var origin:flash.geom.Point=new flash.geom.Point(0,0);
					origin=localToGlobal(origin);
					stage["fullScreenSourceRect"]=new Rectangle(origin.x,origin.y,contentwidth,contentheight);
				}
				catch (e:Error) {   	 
				}
				
				try {
					stage.displayState = "fullScreenInteractive";
					ourFS=true;
				} 
				catch (e:Error) {   	 
					try {
						stage.displayState = StageDisplayState.FULL_SCREEN;  
						ourFS=true;
					}
					catch (e:Error) {
						setSize(beforeFSWidth, beforeFSHeight);  
					}
				}
			}
			else stage.displayState = StageDisplayState.NORMAL;
		}		
		
		// API Events
		public function onPageChanged(page:Number):void {
			dispatchEvent(new PageChangedEvent(page));
		}			
					
		public function onVisibleAreaChanged(area:Object):void {
			dispatchEvent(new VisibleAreaEvent(area));				
		}
		
		public function onZoomChanged(zoom:Number):void {
			dispatchEvent(new ZoomChangedEvent(zoom));
		}			

		public function onToolChanged(tool:String):void {
			dispatchEvent(new ToolChangedEvent(tool));
		}			

		public function onSelection(sel:Object):void {
			dispatchEvent(new Selection(sel));
		}																							

		public function onPageLoaded(page:Number):void {
			dispatchEvent(new PageLoadedEvent(page));
		}					

		public function onPrinted(dummy:Object):void {
			dispatchEvent(new PrintedEvent());
		}						

		public function onLinkClicked(page:Number,url:String):void {
			dispatchEvent(new LinkClickedEvent(page,url));
		}						
		
		public function onBeforeFullScreen(reserved:Object):void {
		}

		public function onAfterFullScreen(reserved:Object):void {
		}

}
}